<?php

///////////////////////////////////////////
/// ADD-ON MENU ///////////////////////////
///////////////////////////////////////////

add_action('pc_addons_menu_ready', 'pcma_in_pc_menu', 50);

function pcma_in_pc_menu($slug) {
	add_submenu_page($slug, 'Mail Actions', 'Mail Actions', 'manage_options', 'pcma_settings', 'pcma_settings');
}
function pcma_settings() {
    include_once(PCMA_DIR . '/settings/view.php');
}






// declare forbidden field indexes ///////
function pcma_forbidden_field_indexes($fields) {
	return array_merge($fields, array('pcma_mc_disclaimer', 'pcma_psw_username'));
}
add_filter('pc_forbidden_field_indexes', 'pcma_forbidden_field_indexes');





// exclude landing page from PvtContent site lock
function pcma_mail_verif_landing_csl_exception($excluded_pages) {
	
	if(pcma_is_active() && get_option('pcma_mv_enable') && get_option('pcma_mv_pag')) {
		$excluded_pages[] = pc_static::wpml_translated_pag_id(get_option('pcma_mv_pag'));
	}
	return $excluded_pages;
}
add_filter('pc_complete_lock_exceptions', 'pcma_mail_verif_landing_csl_exception', 10);






//////////////////////////////////////////////
/// IMPORT FORM - ADD OPTION TO SET NEW PSW //
//////////////////////////////////////////////

function pcma_import_form() {
	
    // only if import notification is on
    if(!get_option('pcma_niu_enable')) {
        return false;    
    }
    ?>
    <tr>
        <td class="pc_label_td"><em>Mail Actions add-on</em> - <?php _e("Create new passwords?", PC_ML); ?></td>
        <td class="pc_field_td">
            <?php $checked = (isset($_POST['pc_imp_auto_psw']) && $_POST['pc_imp_auto_psw']) ? 'checked="checked"' : ''; ?>
            <input type="checkbox" name="pc_imp_auto_psw" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
        </td>
        <td>
            <span class="info"><?php _e("If checked, a new password will be assigned imported users", PC_ML); ?>.<br/><strong><?php _e("In this case, the CSV file must NOT have the password column", PC_ML); ?></strong></span>
        </td>
    </tr>
    <?php
}
add_action('pc_import_form', 'pcma_import_form');






///////////////////////////////////////////////////////////////
//// CUSTOM LABELS IN PAGES LIST TO HELP ORIENTATING //////////
///////////////////////////////////////////////////////////////

function pcma_custom_display_post_states($states, $post) {
    if(!pcma_is_active()) {
        return $states;    
    }
    
    // users e-mail validation - landing page
    if(get_option('pcma_mv_enable') && $post->ID == get_option('pcma_mv_pag')) {
        $states['pcma_mv_landing_pag'] = esc_html__('E-mail Validation Page', PCMA_ML);          
    }
 
    return $states;
}
add_filter('display_post_states', 'pcma_custom_display_post_states', 10, 2);






//////////////////////////////////////////////////////





// user dashboard - tab contents
function pcma_wm_user_dashboard_block_hook($sections, $user_id) {
	if(!get_option('pcma_wm_enable') || $user_id) {return $sections;}

	return 
	$sections + array(
		'pcma_wm' => array(
			'name'		=> 'Mail Actions add-on - '. __('Welcome message', PCMA_ML),
			'classes'	=> 'pc_ud_2_cols_form',
			'callback' 	=> 'pcma_wm_add_user_block'
		)
	);	
}
add_filter('pc_user_dashboard_main_tab_sections', 'pcma_wm_user_dashboard_block_hook', 10, 2);


function pcma_wm_add_user_block($user_id) {
	?>
    <table class="widefat">
      <tbody>
	  	<tr>
        	<th><?php _e("Send welcome message to user?", PCMA_ML) ?></th>
            <td>
            	<input type="checkbox" name="pcma_au_send_welcome" value="1" class="lcwp_sf_check" />
            </td>
        </tr>
      </tbody>
    </table>
<?php
}


